/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.domain.sms.AlarmSmsParams;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatAlarmService;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="remoteAnticheatAlarmService")
public class RemoteAnticheatAlarmServiceImpl
implements RemoteAnticheatAlarmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAnticheatAlarmServiceImpl.class);
    private static final Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<String, Integer>();
    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;
    @Autowired
    private SmsRemindService smsRemindService;

    public static Map<String, Integer> getCouponExchangeMap() {
        return couponExchangeMap;
    }

    public DubboResult<Void> onOrderSuccess(OrderParams order) {
        try {
            this.addExchangeTimes(order.getAppId(), order.getItemId());
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u9632\u4f5c\u5f0a\u8bb0\u5f55\u4f18\u60e0\u5238\u6210\u529f\u8ba2\u5355\u6b21\u6570\uff0c\u5f02\u5e38, orderId=%s, appId=%s, itemId=%s", order.getOrderId(), order.getAppId(), order.getItemId()), (Throwable)e);
            return DubboResult.failResult((String)"\u9632\u4f5c\u5f0a\u8bb0\u5f55\u4f18\u60e0\u5238\u6210\u529f\u8ba2\u5355\u6b21\u6570\uff0c\u5f02\u5e38");
        }
    }

    private void addExchangeTimes(Long appId, Long itemId) throws BizException {
        if (appId == null || itemId == null) {
            return;
        }
        String key = appId + "-" + itemId;
        AnticheatAlarmConfigEntity config = this.anticheatAlarmConfigService.getCacheConfig("app-item-alarm");
        Integer value = couponExchangeMap.putIfAbsent(key, 1);
        if (value == null) {
            return;
        }
        int threshold = config.getThreshold();
        if ((value = Integer.valueOf(value + 1)) == threshold) {
            AlarmSmsParams alarmSmsParams = new AlarmSmsParams();
            alarmSmsParams.setAppId(appId);
            alarmSmsParams.setItemId(itemId);
            alarmSmsParams.setCircle(config.getCircle());
            alarmSmsParams.setDate(DateUtils.getSecondStr((Date)new Date()));
            alarmSmsParams.setValue(value);
            this.smsRemindService.alarm(config.getPhone(), alarmSmsParams);
        }
        couponExchangeMap.put(key, value);
    }
}

