/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.rules.impl;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.remoteservice.rules.RemoteAntiBackendService;
import cn.com.duiba.anticheat.center.api.result.rules.RuleChangeResultDto;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleChangeService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.exception.BizException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteAntiBackendServiceImpl
implements RemoteAntiBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteAntiBackendServiceImpl.class);
    @Autowired
    private RuleChangeService ruleChangeService;

    public RuleChangeResultDto delete(RuleSceneEnum scene, String ruleName) {
        if (scene == null || StringUtils.isBlank((CharSequence)ruleName)) {
            return RuleChangeResultDto.failResult((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.ruleChangeService.delete(scene, ruleName);
        }
        catch (Exception e) {
            log.error("\u89c4\u5219\u5220\u9664\u5f02\u5e38, scene={}, name={}", new Object[]{scene, ruleName, e});
            return RuleChangeResultDto.failResult((String)e.getMessage());
        }
        return RuleChangeResultDto.successResult();
    }

    public RuleChangeResultDto add(RuleSceneEnum scene, String ruleContent, String ruleName) {
        if (scene == null || StringUtils.isBlank((CharSequence)ruleName) || StringUtils.isBlank((CharSequence)ruleContent)) {
            return RuleChangeResultDto.failResult((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.ruleChangeService.add(scene, ruleContent, ruleName);
        }
        catch (Exception e) {
            log.error("\u89c4\u5219\u65b0\u589e\u5f02\u5e38, scene={}, rule={}\uff0cname={}", new Object[]{scene, ruleContent, ruleName, e});
            return RuleChangeResultDto.failResult((String)e.getMessage());
        }
        return RuleChangeResultDto.successResult();
    }

    public RuleChangeResultDto update(RuleSceneEnum scene, String ruleContent, String ruleName) {
        if (scene == null || StringUtils.isBlank((CharSequence)ruleName) || StringUtils.isBlank((CharSequence)ruleContent)) {
            return RuleChangeResultDto.failResult((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.ruleChangeService.update(scene, ruleContent, ruleName);
        }
        catch (Exception e) {
            log.error("\u89c4\u5219\u66f4\u65b0\u5f02\u5e38, scene={}, rule={}\uff0cname={}", new Object[]{scene, ruleContent, ruleName, e});
            return RuleChangeResultDto.failResult((String)e.getMessage());
        }
        return RuleChangeResultDto.successResult();
    }

    public Boolean refresh(RuleSceneEnum scene) throws BizException {
        try {
            return this.ruleChangeService.refresh(scene);
        }
        catch (AnticheatException e) {
            log.error("\u89c4\u5219\u5237\u65b0\u5f02\u5e38, scene={}", (Object)scene, (Object)e);
            throw new BizException(e.getMessage());
        }
    }

    public Boolean open(RuleSceneEnum scene, String ruleName) throws BizException {
        try {
            return this.ruleChangeService.open(scene, ruleName);
        }
        catch (AnticheatException e) {
            log.error("\u89c4\u5219\u6253\u5f00\u5f02\u5e38, scene={}, rule={}", new Object[]{scene, ruleName, e});
            throw new BizException(e.getMessage());
        }
    }
}

