/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskBlackListDto;
import cn.com.duiba.anticheat.center.api.enums.RiskBlackListTypeEnum;
import cn.com.duiba.anticheat.center.api.param.RiskBlackListParam;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskBlackListDao;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskBlackListService;
import cn.com.duiba.api.bo.page.Page;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RiskBlackListServiceImpl
implements RiskBlackListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskBlackListServiceImpl.class);
    @Resource
    private RiskBlackListDao riskBlackListDao;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.riskBlackListDao.deleteByPrimaryKey(id);
    }

    @Override
    public Long insert(RiskBlackListDto record) {
        int insert = this.riskBlackListDao.insert(record);
        return record.getId();
    }

    @Override
    public RiskBlackListDto selectByPrimaryKey(Long id) {
        return this.riskBlackListDao.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(RiskBlackListDto record) {
        return this.riskBlackListDao.updateByPrimaryKeySelective(record);
    }

    @Override
    @Transactional(value="developer_app", rollbackFor={Exception.class})
    public int batchInsert(List<RiskBlackListDto> list) {
        return this.riskBlackListDao.batchInsert(list);
    }

    @Override
    public Page<RiskBlackListDto> listByPage(RiskBlackListParam riskBlackListParam) {
        List<RiskBlackListDto> list = this.riskBlackListDao.listByCondition(riskBlackListParam);
        Integer count = this.riskBlackListDao.selectCountByCondition(riskBlackListParam);
        Page dtoPage = new Page();
        dtoPage.setTotalCount(count.intValue());
        dtoPage.setList(list);
        return dtoPage;
    }

    @Override
    public Boolean checkOnly(Long id, Long appId, Integer riskType, Integer riskScene, String riskValue) {
        RiskBlackListDto riskBlackListDto = this.riskBlackListDao.findByParam(appId, riskType, riskScene, riskValue);
        if (null == riskBlackListDto || Objects.equals(id, riskBlackListDto.getId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean riskBlacklistMatching(Long appId, Integer riskScene, String ip, Long customerId) {
        if (StringUtils.isBlank((CharSequence)ip) || customerId == null) {
            LOGGER.warn("\u4f20\u5165\u7684\u53c2\u6570\u503c\u4e3a\u7a7a, appId:{}, riskScene:{}, ip:{}, customerId:{}", new Object[]{appId, riskScene, ip, customerId});
            return true;
        }
        List<RiskBlackListDto> riskBlackListDtoList = this.riskBlackListDao.findByConsumerIdIP(appId, riskScene, customerId, ip);
        return CollectionUtils.isNotEmpty(riskBlackListDtoList);
    }

    @Override
    @Nullable
    public Integer riskBlacklistMatchingType(Long appId, Integer riskScene, String ip, Long customerId) {
        if (StringUtils.isBlank((CharSequence)ip) || customerId == null) {
            LOGGER.warn("\u4f20\u5165\u7684\u53c2\u6570\u503c\u4e3a\u7a7a, appId:{}, riskScene:{}, ip:{}, customerId:{}", new Object[]{appId, riskScene, ip, customerId});
            return null;
        }
        List<RiskBlackListDto> riskBlackListDtoList = this.riskBlackListDao.findByConsumerIdIP(appId, riskScene, customerId, ip);
        if (CollectionUtils.isNotEmpty(riskBlackListDtoList)) {
            List filterList = riskBlackListDtoList.stream().filter(dto -> Objects.equals(dto.getRiskType(), RiskBlackListTypeEnum.IP.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterList)) {
                return RiskBlackListTypeEnum.IP.getValue();
            }
            return RiskBlackListTypeEnum.CONSUMER.getValue();
        }
        return null;
    }

    @Override
    public List<RiskBlackListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> riskValues) {
        return this.riskBlackListDao.selectByMultValues(appId, riskType, riskScene, riskValues);
    }
}

