/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DayInviteUserHandler
implements DataServerHandler {
    @Autowired
    private SwitchService switchService;
    @Autowired
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
        if (model == null) {
            return;
        }
        if (!(model instanceof HelpCodeModel)) {
            return;
        }
        HelpCodeModel helpCodeModel = (HelpCodeModel)model;
        Long consumerId = helpCodeModel.getConsumerId();
        Long helpConsumerId = helpCodeModel.getHelpConsumerId();
        Long appId = helpCodeModel.getAppId();
        Long activityId = helpCodeModel.getActivityId();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.DAY_INVITE_USERNUM) || consumerId == null || appId == null || activityId == null || helpConsumerId == null) {
            return;
        }
        String hbaseNumKey = this.getUserInviteHbaseKey(consumerId, appId, activityId, "dayInviteUserNum");
        String hbaseKey = this.getUserInviteHbaseKey(consumerId, appId, activityId, String.valueOf(helpConsumerId));
        Long userInfo = this.duibaHbaseRiskService.findByRowKey(hbaseKey);
        if (userInfo == null) {
            this.duibaHbaseRiskService.upsert(hbaseKey, 1L);
            this.duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
        }
    }

    private String getUserInviteHbaseKey(Long consumerId, Long appId, Long activityId, String helpCid) {
        return HbaseKeyEnum.K011.toString() + DateUtils.getDayStr((Date)new Date()) + "_" + consumerId + "_" + appId + "_" + activityId + "_" + helpCid;
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long consumerId = model.getConsumerId();
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.DAY_INVITE_USERNUM) || consumerId == null || appId == null || activityId == null) {
            return 0L;
        }
        String hbaseMaxKey = this.getUserInviteHbaseKey(consumerId, appId, activityId, "dayInviteUserNum");
        Long dayInviteUserNum = this.duibaHbaseRiskService.findByRowKey(hbaseMaxKey);
        return dayInviteUserNum == null ? 0L : dayInviteUserNum;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.DAY_INVITE_USERNUM;
    }
}

