/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotteryTongDunHighStrategy
implements AnticheatLotteryStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatLotteryTongDunHighStrategy.class);
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("tongdun-high").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("tongdun-high").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("tongdun-high");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        if ("not_login".equals(consumer.getPartnerUserId())) {
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        try {
            FraudApiResponse response = TongdunThreadLocal.get().getApiResponse();
            if (response == null) {
                return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
            }
            if (TongdunClient.isReject(response)) {
                Long debugId = this.doMatchProcess(response, consumer, order, request);
                return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
            }
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u76fe\u6821\u9a8c\u5f02\u5e38,", (Throwable)e);
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
    }

    private Long doMatchProcess(FraudApiResponse response, LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        String message = String.format("\u6b64\u8d26\u53f7\u5728\u53c2\u52a0\u6d3b\u52a8(type: %s, duibaActivityId: %s, operatingActivityId: %s)\u65f6\uff0c\u540c\u76fe\u8bc4\u4f30\u98ce\u9669\u7ed3\u679c\u4e3a\u9ad8\uff0c\u540c\u76fe\u6d41\u6c34\u53f7\uff1a%s", order.getType().desc(), order.getDuibaActivityId(), order.getOperatingActivityId(), response.getSeqId());
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("tongdun-high");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(message);
        this.anticheatLotteryDebugLogDao.insert(debug);
        return debug.getId();
    }
}

