/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSwipeSkipStrategy
implements AnticheatStrategy {
    public static final Integer SWIPE_NOT_EXIST = 0;
    public static final Integer SWIPE_EXIST = 1;
    public static final Integer SWIPE_ERROR = 2;
    public static final Integer SWIPE_SKIP = 3;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("swipe-skip").getEnable();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("swipe-skip").getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("swipe-skip").getEffectMode();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("swipe-skip");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Integer swipe = behavior.getSwipe();
        if (Objects.equals(SWIPE_SKIP, swipe)) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("swipe-skip");
        debug.setMessage("\u624b\u52bf\u4e3a\u7a7a(\u975eiphone, ipad, android)\uff0c\u4e0d\u9700\u8981\u9a8c\u8bc1\u624b\u52bf");
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

