package cn.com.duiba.anticheat.center.common.tool;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;

/**
 * hbase row处理类
 * Created by sunchangji on 2018/8/20.
 */
public class HbaseRowKeyTool {
    //由于开发和测试环境用的是同一个hbase,所以根据前缀区分开
    private static final String DEV = "dev_";

    private HbaseRowKeyTool(){
        // X Y
    }

    /**
     * 对habse rowkey做处理
     *
     * @param rowKey
     * @return
     */
    public static String handleRowKey(String rowKey) {

        if (!SpringEnvironmentUtils.isDevEnv()) {
            return mD5HashRowKey(rowKey);
        }
        if (rowKey.startsWith(DEV)) {
            return mD5HashRowKey(rowKey);
        }
        String devRowKey = DEV + rowKey;
        return mD5HashRowKey(devRowKey);
    }

    /**
     * 对rowkey做MD5Hash处理,防止hbase rowkey热点问题
     *
     * @param rowKey
     * @return
     */
    private static String mD5HashRowKey(String rowKey) {
        return MD5Hash.getMD5AsHex(Bytes.toBytes(rowKey));
    }
}
