package cn.com.duiba.anticheat.center.common.tool;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import java.util.concurrent.TimeUnit;

/**
 * 通过短暂的本地缓存来削减redis的访问高峰，尽量避免出现Cannot get Jedis connection，消除对业务的影响
 * Created by xiaoxuda on 2017/9/25.
 */
public class RedisProtectTool {

    private RedisProtectTool() {
        // constructor
    }

    private static Cache<String, Object> cahceByApp = CacheBuilder.newBuilder().maximumSize(10000)
            .expireAfterWrite(10, TimeUnit.SECONDS).build();

    public static Object getFromCache(AdvancedCacheClient advancedCacheClient, String key){
        Object cache = cahceByApp.getIfPresent(key);
        if(cache == null) {
            cache = advancedCacheClient.get(key);
            if(cache != null){
                cahceByApp.put(key, cache);
            }
        }
        return cache;
    }

}
