/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.portal.biz.jpa.apollo.entity;

import com.google.common.base.MoreObjects;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@EntityListeners(value={AuditingEntityListener.class})
public abstract class BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="Id")
    private long id;
    @Column(name="IsDeleted")
    protected boolean isDeleted = false;
    @Column(name="DataChange_CreatedBy", nullable=false)
    private Long dataChangeCreatedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    @Column(name="DataChange_CreatedTime", nullable=false, updatable=false)
    private Date dataChangeCreatedTime;
    @Column(name="DataChange_LastModifiedBy")
    private Long dataChangeLastModifiedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @LastModifiedDate
    @Column(name="DataChange_LastTime", nullable=false)
    private Date dataChangeLastModifiedTime;

    public Long getDataChangeCreatedBy() {
        return this.dataChangeCreatedBy;
    }

    public Date getDataChangeCreatedTime() {
        return this.dataChangeCreatedTime;
    }

    public Long getDataChangeLastModifiedBy() {
        return this.dataChangeLastModifiedBy;
    }

    public Date getDataChangeLastModifiedTime() {
        return this.dataChangeLastModifiedTime;
    }

    public long getId() {
        return this.id;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDataChangeCreatedBy(Long dataChangeCreatedBy) {
        this.dataChangeCreatedBy = dataChangeCreatedBy;
    }

    public void setDataChangeCreatedTime(Date dataChangeCreatedTime) {
        this.dataChangeCreatedTime = dataChangeCreatedTime;
    }

    public void setDataChangeLastModifiedBy(Long dataChangeLastModifiedBy) {
        this.dataChangeLastModifiedBy = dataChangeLastModifiedBy;
    }

    public void setDataChangeLastModifiedTime(Date dataChangeLastModifiedTime) {
        this.dataChangeLastModifiedTime = dataChangeLastModifiedTime;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public void setId(long id) {
        this.id = id;
    }

    @PrePersist
    protected void prePersist() {
        if (this.dataChangeCreatedTime == null) {
            this.dataChangeCreatedTime = new Date();
        }
        if (this.dataChangeLastModifiedTime == null) {
            this.dataChangeLastModifiedTime = new Date();
        }
    }

    @PreUpdate
    protected void preUpdate() {
        this.dataChangeLastModifiedTime = new Date();
    }

    @PreRemove
    protected void preRemove() {
        this.dataChangeLastModifiedTime = new Date();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", this.id).add("dataChangeCreatedBy", (Object)this.dataChangeCreatedBy).add("dataChangeCreatedTime", (Object)this.dataChangeCreatedTime).add("dataChangeLastModifiedBy", (Object)this.dataChangeLastModifiedBy).add("dataChangeLastModifiedTime", (Object)this.dataChangeLastModifiedTime);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }
}

