/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.portal.biz.service;

import cn.com.duiba.apollo.portal.biz.domain.AppConfigKey;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.entity.AccessKey;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.entity.AppConfig;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.repository.AccessKeyRepository;
import cn.com.duiba.apollo.portal.biz.service.AppConfigService;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class AccessKeyService {
    private static final int ACCESSKEY_COUNT_LIMIT = 5;
    @Resource
    private AccessKeyRepository accessKeyRepository;
    @Resource
    private AppConfigService appConfigService;
    private String cluster;

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank((CharSequence)this.cluster)) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u96c6\u7fa4");
        }
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public Boolean enableAccessKey(String appId, Long adminId) {
        boolean enable = this.isAccessKeyEnable(appId);
        AppConfig params = new AppConfig();
        params.setAppId(appId);
        params.setCluster(this.cluster);
        params.setKey("ACCESS_KEY_ENABLE");
        params.setValue(Boolean.toString(!enable));
        params.setDataChangeLastModifiedBy(adminId);
        this.appConfigService.config(params);
        return !enable;
    }

    public boolean isAccessKeyEnable(String appId) {
        AppConfigKey key = new AppConfigKey();
        key.setKey("ACCESS_KEY_ENABLE");
        key.setCluster(this.cluster);
        key.setAppId(appId);
        return this.appConfigService.getBoolean(key);
    }

    public List<AccessKey> findByAppId(String appId) {
        return this.accessKeyRepository.findByClusterAndAppId(this.cluster, appId);
    }

    @Transactional
    public AccessKey create(String appId, Long operator) throws Exception {
        long count = this.accessKeyRepository.countByClusterAndAppId(this.cluster, appId);
        if (count >= 5L) {
            throw new Exception("AccessKeys count limit exceeded");
        }
        String secret = UUID.randomUUID().toString().replaceAll("-", "");
        AccessKey entity = new AccessKey();
        entity.setId(0L);
        entity.setAppId(appId);
        entity.setCluster(this.cluster);
        entity.setSecret(secret);
        entity.setDataChangeLastModifiedBy(operator);
        entity.setDataChangeCreatedBy(operator);
        return (AccessKey)this.accessKeyRepository.save(entity);
    }

    @Transactional
    public AccessKey update(String appId, AccessKey entity) throws Exception {
        long id = entity.getId();
        Long operator = entity.getDataChangeLastModifiedBy();
        AccessKey accessKey = this.accessKeyRepository.findOneByClusterAndAppIdAndId(this.cluster, appId, id);
        if (accessKey == null) {
            throw new Exception("AccessKey not exist");
        }
        accessKey.setEnabled(entity.isEnabled());
        accessKey.setDataChangeLastModifiedBy(operator);
        this.accessKeyRepository.save(accessKey);
        return accessKey;
    }

    @Transactional
    public void delete(String appId, long id, Long operator) throws Exception {
        AccessKey accessKey = this.accessKeyRepository.findOneByClusterAndAppIdAndId(this.cluster, appId, id);
        if (accessKey == null) {
            throw new Exception("AccessKey not exist");
        }
        if (accessKey.isEnabled()) {
            throw new Exception("AccessKey should disable first");
        }
        accessKey.setDeleted(Boolean.TRUE);
        accessKey.setDataChangeLastModifiedBy(operator);
        this.accessKeyRepository.save(accessKey);
    }

    public boolean examine(String appId, String accessKey) {
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            return false;
        }
        if (!this.isAccessKeyEnable(appId)) {
            return false;
        }
        HashSet accessKeys = Sets.newHashSet();
        List<AccessKey> accessKeyList = this.accessKeyRepository.findByClusterAndAppId(this.cluster, appId);
        for (AccessKey key : accessKeyList) {
            if (!key.isEnabled()) continue;
            accessKeys.add(key.getSecret());
        }
        return accessKeys.contains(accessKey);
    }
}

