/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.portal.biz.service;

import cn.com.duiba.apollo.portal.biz.domain.AppConfigKey;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.entity.AppConfig;
import cn.com.duiba.apollo.portal.biz.service.AppConfigService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AppSecretService {
    @Resource
    private AppConfigService appConfigService;
    private String cluster;
    private final LoadingCache<String, String> appSecretCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public @Nullable String load(@NonNull String appId) {
            AppConfigKey configKey = AppSecretService.this.buildAppConfigKey(appId);
            return AppSecretService.this.appConfigService.getString(configKey);
        }
    });

    public void createAppSecret(String appId, String appSecret, Long adminId) {
        AppConfigKey configKey = this.buildAppConfigKey(appId);
        String hasAppSecret = this.appConfigService.getString(configKey);
        if (StringUtils.isNotBlank((String)hasAppSecret)) {
            return;
        }
        AppConfig params = new AppConfig();
        params.setAppId(appId);
        params.setKey("APP_SECRET");
        params.setValue(appSecret);
        params.setDataChangeLastModifiedBy(adminId);
        params.setCluster(this.cluster);
        this.appConfigService.config(params);
    }

    public String getAppSecret(String appId) {
        String appSecret = (String)this.appSecretCache.get((Object)appId);
        if (StringUtils.isBlank((String)appSecret)) {
            this.appSecretCache.invalidate((Object)appId);
        }
        return appSecret;
    }

    private AppConfigKey buildAppConfigKey(String appId) {
        AppConfigKey configKey = new AppConfigKey();
        configKey.setAppId(appId);
        configKey.setKey("APP_SECRET");
        configKey.setCluster(this.cluster);
        return configKey;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }
}

