package cn.com.duiba.apollo.center.api.domain.dto;

import cn.com.duiba.apollo.center.api.constants.ConfigFileFormat;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author liuyao
 */
@Data
public class AppNamespaceDto implements Serializable {

    private String name;
    private String appId;
    private Boolean isPublic;
    private String description;

    public ConfigFileFormat formatAsEnum() {
        String format = ConfigFileFormat.analyFormat(name);
        if(StringUtils.isBlank(format)){
            return ConfigFileFormat.Properties;
        }
        return ConfigFileFormat.fromString(format);
    }

}
