package cn.com.duiba.apollo.center.api.domain.event;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 定义apollo中心事件的事件标识
 * @author liuyao
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ApolloCenterEventInfo {

    String title();

    /**
     * 忽略当前环境
     */
    boolean ignoreCurrentCluster() default false;

    /**
     * 是否持久化消息
     */
    boolean persistence() default false;

}
