/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.dto.AbstractResourceInstanceDto;
import cn.com.duiba.apollo.center.api.domain.params.AbstractResourceInstanceFilter;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 描述: 抽象资源实例
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/6/25 11:37
 */
@AdvancedFeignClient
public interface RemoteAbstractResourceInstanceService {

    List<AbstractResourceInstanceDto> getAll();

    Page<AbstractResourceInstanceDto> getPageByFilter(AbstractResourceInstanceFilter filter, Pageable pageable);

    AbstractResourceInstanceDto getOne(String type, String instanceKey);

    AbstractResourceInstanceDto add(AbstractResourceInstanceDto dto);

    AbstractResourceInstanceDto update(AbstractResourceInstanceDto dto);

    boolean delete(String type, String instanceKey);

    List<AbstractResourceInstanceDto> findByTypeInAndKeyIn(List<String> typeList, List<String> keyList);

}
