package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.dto.AppNamespaceDto;
import cn.com.duiba.apollo.center.api.domain.params.PublicAppNamespaceSearchParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteAppNamespaceService {

    AppNamespaceDto findAppNamespace(String appId, String namespace);

    AppNamespaceDto findPublicAppNamespace(String namespace);
    /**
     * 检索公有的Namespace
     * @param params 检索参数
     */
    List<AppNamespaceDto> findPublicAppNamespaceByNameLike(PublicAppNamespaceSearchParams params);
    /**
     * 检索App下的Namespace
     */
    List<AppNamespaceDto> findAppNamespaces(String appId);

    void createAppNamespace(AppNamespaceDto appNamespace) throws BizException;

    /**
     * 删除AppNamespace
     * @param appId 应用id
     * @param namespace 名称
     */
    void deleteAppNamespace(String appId, String namespace);

}
