package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.params.FetchItems;
import cn.com.duiba.application.boot.api.component.environment.ClusterKey;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 一个环境需要从其他环境fetch配置
 * RemoteItemTransitShipmentService作为配置的中转站
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteItemTransitShipmentService {

    /**
     * 创建Fetch会话，每个会话会存在30秒
     * @param clusterKeys 需要拉取的集群
     */
    String createFetchSession(List<ClusterKey> clusterKeys) throws BizException;

    boolean fetchIsComplete(String sessionId);

    List<FetchItems> fetch(String sessionId);

    void submit(FetchItems params) throws BizException;

}
