package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.dto.ResourceTypeDto;
import cn.com.duiba.apollo.center.api.domain.dto.ResourceTypeSchemaDto;
import cn.com.duiba.apollo.center.api.domain.params.CreateResourceTypeParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteResourceTypeService {

    ResourceTypeDto findByType(String type);

    List<ResourceTypeDto> findAllTypes();

    void createResourceType(CreateResourceTypeParams params) throws BizException;

    void updateResourceType(ResourceTypeDto type) throws BizException;

    List<ResourceTypeSchemaDto> findResourceTypeSchemas(String type);

    ResourceTypeSchemaDto findResourceTypeSchema(String type,String fieldKey);

    void createResourceTypeSchema(ResourceTypeSchemaDto schema) throws BizException;

    void updateResourceTypeSchema(ResourceTypeSchemaDto schema) throws BizException;

    void deleteResourceTypeSchema(String type,String fieldKey) throws BizException;

    boolean indexValue(String type,String fieldKey) throws BizException;

}
