package cn.com.duiba.apollo.center.api.constants;


import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @author Jason Song(song_s@ctrip.com)
 */
public enum ConfigFileFormat {

    /**
     * Properties,公共Namespace指定的配置类型
     */
    Properties("properties"),

    XML("xml"),

    JSON("json"),

    YML("yml"),

    YAML("yaml");

    private static final Map<String,ConfigFileFormat> SUPPORT_FORMATS = Maps.newLinkedHashMap();
    static {
        for(ConfigFileFormat format:ConfigFileFormat.values()){
            SUPPORT_FORMATS.put(format.value,format);
        }
    }

    private final String value;

    ConfigFileFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static String clearFormat(String namespaceName){
        if(StringUtils.isBlank(namespaceName)){
            return namespaceName;
        }
        String format = analyFormat(namespaceName);
        if(StringUtils.isBlank(format)){
            return namespaceName;
        }
        return namespaceName.substring(0,format.length());
    }

    public static String analyFormat(String namespaceName){
        if (StringUtils.isEmpty(namespaceName)) {
            return "";
        }
        int lastIndex = namespaceName.lastIndexOf(".");
        if(lastIndex==-1){
            return "";
        }
        if(StringUtils.endsWith(namespaceName,".")){
            return "";
        }
        String format = namespaceName.substring(lastIndex+1);
        if(!SUPPORT_FORMATS.containsKey(format)){
            return "";
        }
        return format;
    }

    public static ConfigFileFormat fromString(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("value can not be empty");
        }
        ConfigFileFormat format = SUPPORT_FORMATS.get(value);
        if(Objects.nonNull(format)){
            return format;
        }
        throw new IllegalArgumentException(value + " can not map format enum");
    }

    public static boolean isValidFormat(String value) {
        try {
            fromString(value);
            return true;
        } catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(analyFormat("sds.xml"));
        System.out.println(clearFormat("sds.xml"));
    }
}
