package cn.com.duiba.apollo.center.api.domain.dto;

import lombok.Data;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author liuyao
 */
@Data
public class ApolloClusterDto implements Serializable,Comparable<ApolloClusterDto>  {

    private Long id;

    private Long envId;

    private String cluster;

    private String appId;

    @Override
    public int compareTo(@NotNull ApolloClusterDto o) {
        long weight = getEnvId() * 10000L + id;
        long otherWeight = o.getEnvId() * 10000L + o.id;
        return Long.compare(weight, otherWeight);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApolloClusterDto that = (ApolloClusterDto) o;
        return Objects.equals(getEnvId(), that.getEnvId()) &&
                Objects.equals(getCluster(), that.getCluster()) &&
                Objects.equals(appId, that.appId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(getEnvId(), getCluster(), appId);
    }
}
