package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.dto.ResourceTemplateDto;
import cn.com.duiba.apollo.center.api.domain.dto.ResourceTemplateItemDto;
import cn.com.duiba.apollo.center.api.domain.params.InstanceTemplateParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteApolloTemplateService {

    void createResourceTemplate(InstanceTemplateParams params) throws BizException;

    int updateResourceTemplate(InstanceTemplateParams params) throws BizException;

    void deleteResourceTemplate(Long id) throws BizException;

    List<ResourceTemplateDto> findResourceTemplateByType(String type);

    List<ResourceTemplateDto> findResourceTemplateByIds(List<Long> ids);

    ResourceTemplateDto findResourceTemplate(Long id);

    List<ResourceTemplateItemDto> findTemplateItems(Long templateId);



}
