package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.dto.SceneDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteSceneService {

    SceneDto findScene(Long id);

    List<SceneDto> findAllScene();

    void saveScene(SceneDto scene);

    void addSceneOwner(Long sceneId,Long ownerId) throws BizException;

    void deleteSceneOwner(Long sceneId,Long ownerId);

    List<Long> findOwnerIds(Long sceneId);

    Boolean isOwner(Long sceneId,Long ownerId);

}
