/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.center.api.service;

import cn.com.duiba.apollo.center.api.domain.dto.ResourceTemplateItemDto;
import cn.com.duiba.apollo.center.api.domain.params.KeyValue;
import cn.com.duiba.apollo.center.api.domain.params.ResourceRenderParams;
import cn.com.duiba.apollo.center.api.remoteservice.RemoteApolloTemplateService;
import cn.com.duiba.apollo.center.api.utils.RenderUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRenderService {
    private static final Logger log = LoggerFactory.getLogger(ResourceRenderService.class);
    private static final String NATIVE_RENDER_TEMPLATE = "apollo.%s.%s.%s";
    @Resource
    private RemoteApolloTemplateService remoteApolloTemplateService;

    public List<KeyValue> renderInstanceConfigByTemplate(ResourceRenderParams renderParams, List<KeyValue> instanceProperties) {
        ArrayList result = Lists.newArrayList();
        if (Objects.isNull(renderParams.getTemplateId())) {
            return this.renderInstanceConfigByNativeTemplate(renderParams, instanceProperties);
        }
        List<ResourceTemplateItemDto> items = this.remoteApolloTemplateService.findTemplateItems(renderParams.getTemplateId());
        if (items.isEmpty()) {
            return this.renderInstanceConfigByNativeTemplate(renderParams, instanceProperties);
        }
        Properties properties = new Properties();
        properties.put("typeKey", renderParams.getTypeKey());
        properties.put("instanceKey", renderParams.getInstanceKey());
        properties.put("instanceId", renderParams.getInstanceId().toString());
        HashMap passwordMap = Maps.newHashMap();
        for (KeyValue keyValue : instanceProperties) {
            properties.setProperty(keyValue.getKey(), Optional.of(keyValue.getValue()).orElse(""));
            passwordMap.put(keyValue.getKey(), keyValue.isPassword());
        }
        for (ResourceTemplateItemDto resourceTemplateItemDto : items) {
            String key = ResourceRenderService.replaceArgs(resourceTemplateItemDto.getKey(), properties);
            String value = ResourceRenderService.replaceArgs(resourceTemplateItemDto.getValue(), properties);
            Set<String> dependenceKeys = RenderUtils.analysisTemplateDependenceKey(resourceTemplateItemDto.getValue());
            boolean password = false;
            for (String dependenceKey : dependenceKeys) {
                if (!passwordMap.getOrDefault(dependenceKey, false).booleanValue()) continue;
                password = true;
            }
            KeyValue dto = new KeyValue();
            dto.setKey(key);
            dto.setValue(value);
            dto.setComment(resourceTemplateItemDto.getComment());
            dto.setPassword(password);
            result.add(dto);
        }
        return result;
    }

    private List<KeyValue> renderInstanceConfigByNativeTemplate(ResourceRenderParams renderParams, List<KeyValue> instanceProperties) {
        for (KeyValue item : instanceProperties) {
            String key = String.format(NATIVE_RENDER_TEMPLATE, renderParams.getTypeKey(), renderParams.getInstanceKey(), item.getKey());
            item.setKey(key);
        }
        return instanceProperties;
    }

    public static String replaceArgs(String template, Properties properties) {
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        StringBuffer sb = new StringBuffer();
        try {
            Matcher matcher = RenderUtils.RENDER_PATTERN.matcher(template);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = "";
                if (properties.containsKey(name)) {
                    value = properties.getProperty(name, "");
                    value = value.replaceAll("\\$", "\\\\\\$");
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
        }
        catch (Exception e) {
            log.error("\u6e32\u67d3\u5931\u8d25", (Throwable)e);
        }
        return sb.toString();
    }
}

