/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.center.api.utils;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class InputValidator {
    public static final String INVALID_CLUSTER_NAMESPACE_MESSAGE = "Only digits, alphabets and symbol - _ . are allowed";
    public static final String INVALID_NAMESPACE_NAMESPACE_MESSAGE = "not allowed to end with .json, .yml, .yaml, .xml, .properties";
    public static final String CLUSTER_NAMESPACE_VALIDATOR = "[0-9a-zA-Z_.-]+";
    private static final String APP_NAMESPACE_VALIDATOR = "[a-zA-Z0-9._-]+(?<!\\.(json|yml|yaml|xml|properties))$";
    private static final Pattern CLUSTER_NAMESPACE_PATTERN = Pattern.compile("[0-9a-zA-Z_.-]+");
    private static final Pattern APP_NAMESPACE_PATTERN = Pattern.compile("[a-zA-Z0-9._-]+(?<!\\.(json|yml|yaml|xml|properties))$");

    public static boolean isValidClusterNamespace(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return CLUSTER_NAMESPACE_PATTERN.matcher(name).matches();
    }

    public static boolean isValidAppNamespace(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return APP_NAMESPACE_PATTERN.matcher(name).matches();
    }

    public static void main(String[] args) {
        System.out.println(InputValidator.isValidAppNamespace("hhh.xml"));
        System.out.println(InputValidator.isValidAppNamespace("hhh.xmll"));
        System.out.println(InputValidator.isValidAppNamespace("hhh"));
        System.out.println(InputValidator.isValidClusterNamespace("hhh"));
        System.out.println(InputValidator.isValidClusterNamespace("hhh.xml"));
    }
}

