/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.center.api.utils;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class RenderUtils {
    public static final Pattern RENDER_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public static Set<String> analysisTemplateDependenceKey(List<String> texts) {
        HashSet keys = Sets.newHashSet();
        for (String text : texts) {
            keys.addAll(RenderUtils.analysisTemplateDependenceKey(text));
        }
        return keys;
    }

    public static Set<String> analysisTemplateDependenceKey(String text) {
        if (StringUtils.isBlank((String)text)) {
            return Collections.emptySet();
        }
        HashSet keys = Sets.newHashSet();
        Matcher matcher = RENDER_PATTERN.matcher(text);
        while (matcher.find()) {
            String name = matcher.group(1);
            keys.add(name);
        }
        return keys;
    }
}

