/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.core;

import cn.com.duiba.apollo.client.ApolloClientProperties;
import cn.com.duiba.apollo.client.dto.AccessTokenDTO;
import cn.com.duiba.apollo.client.params.ResourceAccessTokenParams;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceAccessTokenService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.NetUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

@Aspect
public class ApolloAccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(ApolloAccessTokenService.class);
    @Resource
    private ApolloClientProperties apolloClientProperties;
    @Resource
    private RemoteResourceAccessTokenService remoteResourceAccessTokenService;
    private AtomicReference<String> reference = new AtomicReference();

    @AfterThrowing(value="execution(* cn.com.duiba.apollo.client.remoteservice.RemoteResourceAccessTokenService.verifyAccessToken(..))", throwing="throwable")
    public void afterThrowing(Throwable throwable) {
        if (throwable instanceof BizException) {
            log.error("accessToken\u9a8c\u8bc1\u5931\u8d25" + this.reference.get(), throwable);
            this.flashAccessToken();
        }
    }

    public String getAccessToken() {
        if (StringUtils.isBlank((CharSequence)this.reference.get())) {
            this.flashAccessToken();
        }
        if (StringUtils.isBlank((CharSequence)this.reference.get())) {
            throw new RuntimeException("\u672a\u80fd\u83b7\u53d6\u5230accessToken");
        }
        return this.reference.get();
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    public void autoFlushAccessToken() {
        if (StringUtils.isBlank((CharSequence)this.reference.get())) {
            return;
        }
        this.flashAccessToken();
    }

    private synchronized void flashAccessToken() {
        if (StringUtils.isBlank((CharSequence)this.apolloClientProperties.getAccessKey()) || StringUtils.isBlank((CharSequence)this.apolloClientProperties.getAccessSecret())) {
            return;
        }
        ResourceAccessTokenParams params = new ResourceAccessTokenParams();
        params.setAccessKey(this.apolloClientProperties.getAccessKey());
        params.setAccessSecret(this.apolloClientProperties.getAccessSecret());
        params.setIp(NetUtils.getLocalIp());
        try {
            AccessTokenDTO accessTokenDTO = this.remoteResourceAccessTokenService.acquireAccessToken(params);
            String accessToken = this.reference.getAndSet(accessTokenDTO.getAccessToken());
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                this.remoteResourceAccessTokenService.deleteAccessToken(accessToken);
            }
        }
        catch (BizException e) {
            log.error("\u83b7\u53d6accessToken\u5931\u8d25", (Throwable)e);
            this.reference.set(null);
        }
    }
}

