/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.rocketmq;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ConfigServerEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigServerEventListener.class);
    @Resource
    private ApplicationContext applicationContext;

    void onMessage(MessageExt messageExt) {
        Class<?> eventClass;
        String className = messageExt.getUserProperty("CONFIG_SERVER_EVENT_CLASS");
        if (StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        try {
            eventClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.debug("\u4e0d\u652f\u6301\u4e8b\u4ef6:" + className);
            return;
        }
        String json = new String(messageExt.getBody(), Charset.forName("utf-8"));
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        Object event = jsonObject.toJavaObject(eventClass);
        this.applicationContext.publishEvent(event);
    }
}

