package cn.com.duiba.apollo.client;

import cn.com.duiba.apollo.client.core.ApolloAccessTokenService;
import cn.com.duiba.apollo.client.core.ApolloClient;
import cn.com.duiba.apollo.client.rocketmq.ApolloClientRocketmqConfiguration;
import cn.com.duiba.apollo.client.utils.HttpClientBox;
import org.apache.http.client.HttpClient;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.Optional;

@EnableScheduling
@Configuration
@Import({
        ApolloClientRocketmqConfiguration.class
})
@EnableConfigurationProperties(ApolloClientProperties.class)
public class ApolloClientConfiguration {

    @Bean(initMethod = "init")
    public ApolloClient apolloClient(HttpClient httpClient,ApolloClientProperties apolloClientProperties,Environment environment){

        String url = Optional.ofNullable(apolloClientProperties.getServerUrl()).orElse(environment.getProperty("spring.cloud.config.uri"));

        HttpClientBox box = new HttpClientBox(httpClient);
        box.setConfigServerUrl(url);
        ApolloClient client = new ApolloClient();
        client.setHttpClientBox(box);
        return client;
    }

    @Bean
    public ApolloAccessTokenService apolloAccessTokenService(){
        return new ApolloAccessTokenService();
    }

}
