package cn.com.duiba.apollo.client.core;

import cn.com.duiba.apollo.client.ApolloClientProperties;
import cn.com.duiba.apollo.client.utils.HttpClientBox;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Scheduled;

import javax.annotation.Resource;
import java.util.Map;

@Slf4j
public class ApolloAccessTokenService {

    private HttpClientBox httpClientBox;

    @Resource
    private ApolloClientProperties apolloClientProperties;

    private volatile String accessToken;

    String getAccessToken(){
        if(StringUtils.isBlank(accessToken)){
            synchronized (this){
                if(StringUtils.isBlank(accessToken)){
                    flashAccessToken();
                }
            }
        }
        return accessToken;
    }

    @Scheduled(cron = "0 0 0/1 * * ?")
    public synchronized void flashAccessToken(){
        if(httpClientBox==null){
            return;
        }
        assert StringUtils.isNotBlank(apolloClientProperties.getAccessKey());
        assert StringUtils.isNotBlank(apolloClientProperties.getAccessSecret());

        while (true){

            Map<String,String> params = Maps.newHashMap();
            params.put("accessKey",apolloClientProperties.getAccessKey());
            params.put("accessSecret",apolloClientProperties.getAccessSecret());

            try{
                JSONObject result = httpClientBox.request("/apolloApi/access/accessToken",params, JSONObject.class);
                if(result.containsKey("error")){
                    throw new Exception(result.getString("message"));
                }
                accessToken = result.getString("accessToken");
                break;
            }catch (Exception e){
                log.error("获取accessToken失败",e);
            }
        }
    }

    void setHttpClientBox(HttpClientBox httpClientBox) {
        this.httpClientBox = httpClientBox;
    }
}
