package cn.com.duiba.apollo.client.core;

import cn.com.duiba.apollo.client.dto.PagenationDTO;
import cn.com.duiba.apollo.client.dto.ResourceInstanceDTO;
import cn.com.duiba.apollo.client.dto.ResourceTypeDTO;
import cn.com.duiba.apollo.client.dto.ResourceTypeDetailsDTO;
import cn.com.duiba.apollo.client.event.ResourceInstanceFlushEvent;
import cn.com.duiba.apollo.client.utils.HttpClientBox;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Slf4j
public class ApolloClient {

    private HttpClientBox httpClientBox;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;

    public void init(){
        apolloAccessTokenService.setHttpClientBox(httpClientBox);
    }

    public void setHttpClientBox(HttpClientBox httpClientBox) {
        this.httpClientBox = httpClientBox;
    }

    @EventListener(ResourceInstanceFlushEvent.class)
    public void resourceInstanceFlushEventAccept(ResourceInstanceFlushEvent event){
        log.info("消息更新："+event.getInstanceId());
    }


    public List<ResourceTypeDTO> findAllResourceTypes(){
        return httpClientBox.request( "/apolloApi/resource/findAllResourceTypes", List.class);
    }

    public ResourceTypeDetailsDTO findResourceTypeDetails(Long typeId){
        Map<String,String> params = Maps.newHashMap();
        params.put("typeId",typeId.toString());
        return httpClientBox.request("/apolloApi/resource/findResourceTypeDetails",params, ResourceTypeDetailsDTO.class);
    }

    public PagenationDTO<ResourceInstanceDTO> findInstancePage(
            Long typeId,
            String key,
            Integer pageIndex,
            Integer pageSize){
        Map<String,String> params = Maps.newHashMap();
        params.put("typeId",typeId.toString());
        if(StringUtils.isNotBlank(key)){
            params.put("key",key);
        }
        params.put("pageIndex",pageIndex.toString());
        params.put("pageSize",pageSize.toString());
        return httpClientBox.request("/apolloApi/resource/findInstancePage",params, PagenationDTO.class);
    }

    public Properties findOneInstanceProperties(Long instanceId){
        Map<String,String> params = Maps.newHashMap();
        params.put("instanceId",instanceId.toString());
        params.put("accessToken",apolloAccessTokenService.getAccessToken());
        Properties properties = httpClientBox.request("/apolloApi/resource/findOneInstanceProperties",params,Properties.class);
        if(properties.contains("$$error")){
            throw new RuntimeException(properties.getProperty("$$message"));
        }
        return properties;
    }




}
