package cn.com.duiba.apollo.client.rocketmq;

import lombok.Data;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.springframework.boot.context.properties.ConfigurationProperties;


@Data
@ConfigurationProperties(prefix = "apollo.client.rocketmq")
public class ApolloClientRocketmqProperties {

    private String nameServer;

    private String topic;

    private String group;

    private Boolean broadcasting = false;//默认集群消费
    /**
     * if orderly is true, using {@link MessageListenerOrderly} else if orderly if false,
     * using {@link MessageListenerConcurrently}
     */
    private Boolean orderly = false;

    /**
     * The concurrency setting of the consumer. Default: 20.
     */
    private int concurrency = 20;

}
