package cn.com.duiba.apollo.client.rocketmq;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.nio.charset.Charset;

/**
 *
 */
@Slf4j
public class ConfigServerEventListener {

    @Resource
    private ApplicationContext applicationContext;

    void onMessage(MessageExt messageExt){
        String className = messageExt.getUserProperty(MessageHead.CONFIG_SERVER_EVENT_CLASS);
        if(StringUtils.isBlank(className)){
            return;
        }
        Class<?> eventClass;
        try{
            eventClass = Class.forName(className);
        }catch (ClassNotFoundException e){
            log.info("不支持事件:"+className);
            return;
        }
        String json = new String(messageExt.getBody(), Charset.forName("utf-8"));
        JSONObject jsonObject = JSONObject.parseObject(json);
        Object event = jsonObject.toJavaObject(eventClass);
        applicationContext.publishEvent(event);
    }

}
