package cn.com.duiba.apollo.client.utils;

import lombok.Data;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.apache.http.client.HttpClient;

import java.util.Map;
import java.util.Objects;

public class HttpClientBox {

    private RestTemplate restTemplate;

    private String configServerUrl;

    public HttpClientBox(HttpClient httpClient){
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(15000);
        httpRequestFactory.setHttpClient(httpClient);
        restTemplate = new RestTemplate(httpRequestFactory);
    }

    public void setConfigServerUrl(String configServerUrl) {
        this.configServerUrl = configServerUrl;
    }

    public <T> T request(String path, Map<String,String> params, Class<T> resultClass){
        String url = configServerUrl+path;
        if(Objects.nonNull(params)){
            url = UrlUtils.appendParams(url,params);
        }
        return restTemplate.getForObject(url,resultClass);
    }


    public <T> T request(String path,Class<T> resultClass){
        return request(path,null,resultClass);
    }


}
