package cn.com.duiba.apollo.client.params;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

@Data
public class StartReferenceParams implements Serializable {

    private Long templateId;//指定模板

    private String instanceAlias;//自定义实例标识

    public boolean isEnable(){
        return Objects.nonNull(templateId) || StringUtils.isNotBlank(instanceAlias);
    }

}
