package cn.com.duiba.apollo.client.remoteservice;

import cn.com.duiba.apollo.client.dto.KeyValueDTO;
import cn.com.duiba.apollo.client.dto.PagenationDTO;
import cn.com.duiba.apollo.client.dto.ResourceInstanceDTO;
import cn.com.duiba.apollo.client.dto.ResourceTypeDTO;
import cn.com.duiba.apollo.client.params.InstanceConfigParams;
import cn.com.duiba.apollo.client.params.ResourceInstancePageParams;
import cn.com.duiba.apollo.client.params.ResourceInstanceParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteResourceInstanceService {

    /**
     * 拉取所有的资源类型
     * @return 资源类型列表
     */
    List<ResourceTypeDTO> findAllResourceTypes();

    /**
     * 根据Key查询
     * @param key
     * @return
     */
    ResourceTypeDTO findTypeByKey(String key);
    /**
     * 根据id查询查询实例类型
     * @param id
     * @return
     */
    ResourceTypeDTO findTypeById(Long id);
    /**
     * 查询单个资源实例
     */
    ResourceInstanceDTO findOneInstance(Long id);
    /**
     * 批量获取资源实例
     * @param ids 资源实例id
     * @return 资源实例列表
     */
    List<ResourceInstanceDTO> findInstancesByIds(List<Long> ids);

    /**
     * 拉取一个资源类型下的资源实例分页列表
     * @param pageParams 查询参数
     * @return 资源实例
     */
    PagenationDTO<ResourceInstanceDTO> findInstancePage(ResourceInstancePageParams pageParams) throws BizException;

    /**
     * 根据关键字查询实例类
     */
    List<ResourceInstanceDTO> findInstanceByKey(ResourceInstanceParams params) throws BizException;

    /**
     * 获取资源实例的原生配置（不进行渲染）
     * 注：密码字段不可用
     * @param id 资源实例id
     * @throws BizException id不合法
     */
    List<KeyValueDTO> findInstanceNativeConfig(Long id) throws BizException;
    /**
     * 预览一个资源实例的配置（预览模式会屏蔽密码字段）
     * @return 资源引用
     **/
    List<KeyValueDTO> previewOneInstanceConfig(String accessToken,InstanceConfigParams params) throws BizException;

}
