package cn.com.duiba.apollo.client.rocketmq;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;

import javax.annotation.Resource;
import java.nio.charset.Charset;

@Slf4j
public class ApolloEventProducer {

    @Resource(name = "apolloMQProducer")
    private DefaultMQProducer apolloMQProducer;
    @Resource
    private ApolloClientRocketmqProperties apolloClientRocketmqProperties;

    public void publishEvent(Object event){

        String json = JSONObject.toJSONString(event);
        Message msg = new Message(apolloClientRocketmqProperties.getTopic(),json.getBytes(Charset.forName("utf-8")));
        msg.putUserProperty(MessageHead.CONFIG_SERVER_EVENT_CLASS, event.getClass().getName());
        try{
            SendResult sendResult = apolloMQProducer.send(msg);
            log.debug("资源实例更新事件:"+sendResult.getSendStatus());
        }catch (Exception e){
            log.error("资源实例更新事件发布失败",e);
        }
    }

}
