
package cn.com.duiba.apollo.client.rocketmq;

import cn.com.duiba.apollo.client.event.InstanceReferenceEvent;
import cn.com.duiba.apollo.client.event.NamespaceReleaseEvent;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 *
 */
@Slf4j
public class ConfigServerEventListener {

    private static Map<String,Class<?>> EVENT_CLASS_MAP = Maps.newConcurrentMap();
    static {
        regestEventClass(InstanceReferenceEvent.class);
        regestEventClass(NamespaceReleaseEvent.class);
    }

    @Resource
    private ApplicationContext applicationContext;

    void onMessage(MessageExt messageExt){
        String className = messageExt.getUserProperty(MessageHead.CONFIG_SERVER_EVENT_CLASS);
        if(StringUtils.isBlank(className)){
            return;
        }
        Class<?> eventClass = EVENT_CLASS_MAP.get(className);
        if(Objects.isNull(eventClass)){
            return;
        }
        String json = new String(messageExt.getBody(), Charset.forName("utf-8"));
        JSONObject jsonObject = JSONObject.parseObject(json);
        Object event = jsonObject.toJavaObject(eventClass);
        applicationContext.publishEvent(event);
    }

    private static void regestEventClass(Class<?> eventClass){
        EVENT_CLASS_MAP.put(eventClass.getName(),eventClass);
    }

}
