/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.rocketmq;

import cn.com.duiba.apollo.client.event.InstanceReferenceEvent;
import cn.com.duiba.apollo.client.event.NamespaceReleaseEvent;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ConfigServerEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigServerEventListener.class);
    private static Map<String, Class<?>> EVENT_CLASS_MAP = Maps.newConcurrentMap();
    @Resource
    private ApplicationContext applicationContext;

    void onMessage(MessageExt messageExt) {
        String className = messageExt.getUserProperty("CONFIG_SERVER_EVENT_CLASS");
        if (StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        Class<?> eventClass = EVENT_CLASS_MAP.get(className);
        if (Objects.isNull(eventClass)) {
            return;
        }
        String json = new String(messageExt.getBody(), Charset.forName("utf-8"));
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        Object event = jsonObject.toJavaObject(eventClass);
        this.applicationContext.publishEvent(event);
    }

    private static void regestEventClass(Class<?> eventClass) {
        EVENT_CLASS_MAP.put(eventClass.getName(), eventClass);
    }

    static {
        ConfigServerEventListener.regestEventClass(InstanceReferenceEvent.class);
        ConfigServerEventListener.regestEventClass(NamespaceReleaseEvent.class);
    }
}

