/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.service.rocketmq;

import cn.com.duiba.apollo.client.service.rocketmq.ApolloClientRocketmqProperties;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloEventProducer {
    private static final Logger log = LoggerFactory.getLogger(ApolloEventProducer.class);
    @Resource(name="apolloMqProducer")
    private DefaultMQProducer apolloMqProducer;
    @Resource
    private ApolloClientRocketmqProperties apolloClientRocketmqProperties;

    public void publishEvent(Object event) {
        String json = JSONObject.toJSONString((Object)event);
        Message msg = new Message(this.apolloClientRocketmqProperties.getTopic(), json.getBytes(StandardCharsets.UTF_8));
        msg.putUserProperty("CONFIG_SERVER_EVENT_CLASS", event.getClass().getName());
        try {
            SendResult sendResult = this.apolloMqProducer.send(msg);
            log.debug("\u8d44\u6e90\u5b9e\u4f8b\u66f4\u65b0\u4e8b\u4ef6:" + sendResult.getSendStatus());
        }
        catch (Exception e) {
            log.error("\u8d44\u6e90\u5b9e\u4f8b\u66f4\u65b0\u4e8b\u4ef6\u53d1\u5e03\u5931\u8d25", (Throwable)e);
        }
    }
}

