package cn.com.duiba.apollo.client.remoteservice;

import cn.com.duiba.apollo.client.dto.AccessTokenDTO;
import cn.com.duiba.apollo.client.params.ResourceAccessTokenParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteResourceAccessTokenService {

    AccessTokenDTO acquireAccessToken(ResourceAccessTokenParams params) throws BizException;

    /**
     * 验证accessToken有效性
     * @param accessToken 入参
     * @return userId
     * @throws BizException 验证失败
     */
    Long verifyAccessToken(String accessToken) throws BizException;

    void deleteAccessToken(String accessToken);

}
