package cn.com.duiba.apollo.client.remoteservice;

import cn.com.duiba.apollo.center.api.domain.params.KeyValue;
import cn.com.duiba.apollo.client.dto.KeyValueDTO;
import cn.com.duiba.apollo.client.dto.PagenationDTO;
import cn.com.duiba.apollo.client.dto.ResourceInstanceDTO;
import cn.com.duiba.apollo.client.params.InstanceConfigParams;
import cn.com.duiba.apollo.client.params.ResourceInstancePageParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteResourceInstanceService {

    /**
     * 查询单个资源实例
     */
    ResourceInstanceDTO findOneInstance(Long id);

    /**
     * 获取一个实例
     * @param typeKey
     * @param instanceKey
     * @return
     */
    ResourceInstanceDTO findOneInstanceByKey(String typeKey,String instanceKey);

    /**
     * 批量获取资源实例
     * @param ids 资源实例id
     * @return 资源实例列表
     */
    List<ResourceInstanceDTO> findInstancesByIds(List<Long> ids);

    /**
     * 拉取一个资源类型下的资源实例分页列表
     * @param pageParams 查询参数
     * @return 资源实例
     */
    PagenationDTO<ResourceInstanceDTO> findInstancePage(ResourceInstancePageParams pageParams) throws BizException;

    /**
     * 获取资源实例的原生配置（不进行渲染）
     * 注：密码字段不可用
     * @param id 资源实例id
     * @throws BizException id不合法
     */
    List<KeyValue> findInstanceNativeConfig(Long id) throws BizException;
    /**
     * 预览一个资源实例的配置（预览模式会屏蔽密码字段）
     * @return 资源引用
     **/
    List<KeyValue> previewOneInstanceConfig(String accessToken, InstanceConfigParams params) throws BizException;

}
