package cn.com.duiba.apollo.client.service.resource;

import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.apollo.client.dto.ReferenceReleaseDTO;
import cn.com.duiba.apollo.client.event.InstanceReferenceEvent;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceReferenceService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorExclude;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

import javax.annotation.Nonnull;
import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
@Slf4j
public class ResourceReferenceClientService {

    @Resource
    private RemoteResourceReferenceService remoteResourceReferenceService;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;

    @CacheMonitorExclude
    private final LoadingCache<Long, ReferenceReleaseDTO> cache = Caffeine.newBuilder().expireAfterWrite(10, TimeUnit.MINUTES).build(new CacheLoader<Long, ReferenceReleaseDTO>() {
        @Override
        public ReferenceReleaseDTO load(@Nonnull Long referenceId) {
            String accessToken = apolloAccessTokenService.getAccessToken();
            try {
                return remoteResourceReferenceService.findReferencePublishItems(accessToken,referenceId);
            }catch (BizException e){
                log.error("加载资源实例配置失败",e);
                return new ReferenceReleaseDTO();
            }
        }
    });

    @Order(Integer.MIN_VALUE)
    @EventListener(InstanceReferenceEvent.class)
    public void instanceReferenceEventListener(InstanceReferenceEvent event){
        cache.invalidate(event.getReferenceId());
    }

    public ReferenceReleaseDTO findReferenceProperties(Long referenceId) {
        return  Objects.requireNonNull(cache.get(referenceId));
    }
}
