
package cn.com.duiba.apollo.client.service.stream;

import cn.com.duiba.application.boot.stream.annotation.StreamListener;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.util.Objects;

/**
 *
 * @author liuyao
 */
@Slf4j
public class ConfigServerEventListener {

    public static final String APOLLO_STREAM_NAME = "apollo";

    private final LoadingCache<String,Class<?>> eventTypeCache = Caffeine.newBuilder().build(new CacheLoader<String, Class<?>>() {
        @Nullable
        @Override
        public Class<?> load(@NonNull String type) {
            try{
                return Class.forName(type);
            }catch (Exception e){
                log.error("异常事件",e);
                return null;
            }
        }
    });

    @Resource
    private ApplicationContext applicationContext;

    @StreamListener(APOLLO_STREAM_NAME)
    public void onMessage(ApolloClientMessage message){
        String type = message.getType();
        Class<?> eventType = eventTypeCache.get(type);
        if(Objects.isNull(eventType)){
            return;
        }
        applicationContext.publishEvent(JSONObject.parseObject(message.getBody(),eventType));
    }

}
