/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.apollo.client.dto;

import cn.com.duiba.apollo.client.enums.ItemViewStatusEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 描述: apollo config server 键值对
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/8/23 14:34
 */
@Data
public class ItemViewDTO implements Serializable {

    private static final long serialVersionUID = -2273304383049717684L;

    private String key;

    private String oldValue;

    private String newValue;

    /**
     * @see ItemViewStatusEnum
     */
    private Integer status;

}
