package cn.com.duiba.apollo.client.dto;

import cn.com.duiba.apollo.client.utils.PasswordUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Properties;

@Data
public class ReferenceReleaseDTO implements Serializable {

    private Properties configurations = new Properties();

    private Properties instanceConfigurations = new Properties();

    private Boolean hasRelease = false;

    private String releaseKey = "";

    public Properties getReleaseProperties(){
        return getReleaseProperties(false);
    }

    public Properties getReleaseProperties(boolean decode){
        Properties properties = new Properties();
        properties.putAll(instanceConfigurations);
        properties.putAll(configurations);

        if(decode){
            for(String key:properties.stringPropertyNames()){
                properties.put(key, PasswordUtils.decryptValue(properties.getProperty(key)));
            }
        }
        return properties;
    }

}