/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.apollo.client.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 描述: item的对外状态
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/8/23 14:56
 */
@Getter
@AllArgsConstructor
public enum ItemViewStatusEnum {

    RELEASED(1, "已发布"),

    MODIFIED(2, "已修改"),

    DELETED(3, "已删除");

    private int code;

    private String desc;

    public static ItemViewStatusEnum transfer(int code) {
        for (ItemViewStatusEnum value : ItemViewStatusEnum.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        throw new IllegalArgumentException("无效code");
    }

}
