/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.apollo.client.params;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 描述: apollo
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/8/23 14:25
 */
@Data
@NoArgsConstructor
public class ApolloConfigBaseParams extends BaseSsoParams {

    private static final long serialVersionUID = 4229049983821980710L;

    private String appName;

    private String namespaceName;

    public ApolloConfigBaseParams(Long adminId, String appName) {
        super(adminId);
        this.appName = appName;
    }

    public ApolloConfigBaseParams(Long adminId, String appName, String namespaceName) {
        super(adminId);
        this.appName = appName;
        this.namespaceName = namespaceName;
    }
}
