/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.apollo.client.remoteservice;

import cn.com.duiba.apollo.client.dto.ItemViewDTO;
import cn.com.duiba.apollo.client.params.ApolloConfigBaseParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 描述: apollo自动化维护配置api
 * <p>
 * 针对自动维护配置的namespace
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/8/23 14:04
 */
@AdvancedFeignClient
public interface RemoteApolloConfigServerService {

    List<ItemViewDTO> findAll(ApolloConfigBaseParams params) throws BizException;

    List<ItemViewDTO> findByKeyList(List<String> keyList, ApolloConfigBaseParams params) throws BizException;

    ItemViewDTO findByKey(String key, ApolloConfigBaseParams params) throws BizException;

    void save(String key, String value, ApolloConfigBaseParams params) throws BizException;

    void delete(String key, ApolloConfigBaseParams params) throws BizException;

    void release(String releaseTitle, ApolloConfigBaseParams params) throws BizException;

}
