package cn.com.duiba.apollo.client.service.stream;

import cn.com.duiba.apollo.client.event.ApolloClientEvent;
import com.alibaba.fastjson.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;

/**
 * @author liuyao
 */
public class ApolloMessageConverter implements MessageConverter {

    @Override
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return null;
    }

    @Override
    public Message<?> toMessage(@NotNull Object payload, MessageHeaders headers) {
        if(!(payload instanceof ApolloClientEvent)){
            return null;
        }
        ApolloClientMessage message = new ApolloClientMessage();
        message.setBody(JSONObject.toJSONString(payload));
        message.setType(payload.getClass().getName());
        return MessageBuilder.createMessage(message,headers);
    }
}
