/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.service.stream;

import cn.com.duiba.apollo.client.service.stream.ApolloClientMessage;
import cn.com.duibaboot.ext.stream.annotation.StreamListener;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Objects;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ConfigServerEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigServerEventListener.class);
    public static final String APOLLO_STREAM_NAME = "apollo";
    private final LoadingCache<String, Class<?>> eventTypeCache = Caffeine.newBuilder().build(new CacheLoader<String, Class<?>>(){

        public @Nullable Class<?> load(@NonNull String type) {
            try {
                return Class.forName(type);
            }
            catch (Exception e) {
                log.error("\u5f02\u5e38\u4e8b\u4ef6", (Throwable)e);
                return null;
            }
        }
    });
    @Resource
    private ApplicationContext applicationContext;

    @StreamListener(value="apollo")
    public void onMessage(ApolloClientMessage message) {
        String type = message.getType();
        Class eventType = (Class)this.eventTypeCache.get((Object)type);
        if (Objects.isNull(eventType)) {
            return;
        }
        this.applicationContext.publishEvent(JSONObject.parseObject((String)message.getBody(), (Class)eventType));
    }
}

