/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Map;
import javax.annotation.Resource;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=2)
public class MappingModeSleathPlugin
implements RequestInterceptor {
    @Resource
    private Tracer tracer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(RequestTemplate template) {
        Map headers = template.headers();
        if (!headers.containsKey("X-MAPPING-MODE-AUTH")) {
            return;
        }
        template.header("X-B3-Flags", new String[]{"0"});
        if (!this.tracer.isTracing() || !this.tracer.getCurrentSpan().isExportable()) {
            return;
        }
        Span span = this.tracer.createSpan(RpcContext.getContext().getTargetServiceId() + ":/" + RpcContext.getContext().getMethod());
        try {
            span.tag("lc", "app-boot-mappingmode");
            span.tag("peer.service", template.method());
            span.logEvent("cs");
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }
}

